<?php

namespace App\Http\Controllers\Site\Student\Promotion;

use App\Models\Academic\AcademicAdmissionType;
use App\Models\Academic\AcademicSection;
use App\Models\Academic\SubjectCondition;
use App\Models\Site\Fee\Fine\SiteStudentFeeFine;
use App\Models\Site\Fee\SiteStudentFeeDemandSlipDetails;
use App\Models\Site\Fee\SiteStudentFeePaymentHistory;
use App\Models\Site\Result\SiteIndividualCombineSubjectResultStore;
use App\Models\Site\Result\SiteStudentPrimaryResultDetail;
use App\Models\Site\SiteShiftClassGroupSectionSetting;
use App\Models\Site\Student\Promotion\StudentPromotionHistory;
use App\Models\Site\Student\Promotion\GlobalStudentPromotionHistory;
use App\Models\Student\StudentHistory;
use App\Models\SubjectGroupConditionSetting\SubjectGroupConditionSetting;
use Carbon\Carbon;
use Error;
use App\Models\Site\Student\GlobalStudentHistory;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Site\Fee\GlobalSiteStudentFeeDemandSlipDetails;
use App\Models\SubjectGroupConditionSetting\GlobalSubjectGroupConditionSetting;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
//use Nexmo\Response;
use phpDocumentor\Reflection\Types\Null_;
use Response;
use Session;

class StudentPromotionController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    private $studentPromotionHistory;

    public function __construct(StudentPromotionHistory $studentPromotionHistory)
    {
//        $this->middleware('login');
        $this->studentPromotionHistory = $studentPromotionHistory;
        $this->middleware('auth');
        $this->middleware('sitepagechecker');


    }
    public function index()
    {
        $viewType = 'Promotion';

        return view('default.admin.layouts.master',compact('viewType'));
//        return view('default.admin.site.student.promotion.index',compact('viewType'));
    }

    public function getStudentResultFeeDataList(Request $request)
    {
//        return $request->academic_section_id;;
        $academic_version_id = $request->academic_version_id;
        $academic_shift_id = $request->academic_shift_id;
        $academic_year_id = $request->academic_year_id;
        $academic_session_id = $request->academic_session_id;
        $academic_class_id = $request->academic_class_id;
        $academic_class_group_id = $request->academic_class_group_id;
        $academic_department_id = $request->academic_department_id;
        $academic_section_id = $request->academic_section_id;

        $std_history_data = StudentHistory::where('academic_version_id',$academic_version_id)
            ->with(['student'=>function ($query) {
                $query->where('user_type', 'student');
                $query->select('id');

            }])
            ->select('id', 'user_id', 'student_roll_number')
            ->where('academic_year_id', $academic_year_id)
            ->where('academic_shift_id', $academic_shift_id)
            ->when($academic_class_id, function ($query) use($academic_class_id){
                $query->where('academic_class_id', $academic_class_id);
            })
            ->when($academic_department_id, function ($query) use($academic_department_id){
                $query->where('academic_department_id', $academic_department_id);
            })
            ->when($academic_class_group_id, function ($query) use($academic_class_group_id){
                $query->where('academic_class_group_id', $academic_class_group_id);
            })
            ->when($academic_section_id, function ($query) use($academic_section_id){
                $query->where('academic_section_id', $academic_section_id);
            })
            ->when($academic_session_id, function ($query) use($academic_session_id){
                $query->where('academic_session_id', $academic_session_id);
            })
            ->where('status', 1)
            ->where('transfer_status', 0)
            ->orderBy('student_roll_number')
            ->orderBy('academic_department_id')
            ->orderBy('academic_class_id')
            ->orderBy('academic_class_group_id')
            ->orderBy('academic_section_id')
            ->get();

//        return $std_history_data;

        $student_ids=$std_history_data->pluck('id')->unique();
//        return $student_ids;


        $std_demand_slip_list = SiteStudentFeeDemandSlipDetails::select('id', 'student_history_id', 'total_amount')
            ->whereIn('student_history_id', $student_ids)
            ->where('status', 1)
            ->get();

        $std_payment_history_list = SiteStudentFeePaymentHistory::select('id', 'student_history_id', 'due_amount')
            ->whereIn('student_history_id', $student_ids)
            ->where('status', 1)
            ->orderBy('id','DESC')
            ->get();
//return $std_payment_history_list;

        if($request->result_condition=='Pass'){

            $student_result_list=SiteStudentPrimaryResultDetail::whereIn('student_history_id', $student_ids)
                ->where('academic_result_primary_type_id', $request->academic_result_primary_type_id)
                ->where('exam_attendance_status', true)
                ->where('fail_subject_count', '<=', 0)
                ->select('id', 'student_history_id', 'academic_result_primary_type_id', 'fail_subject_count', 'gpa')
                ->get();

        }
        else if($request->result_condition=='Fail'){
            $student_result_list=SiteStudentPrimaryResultDetail::whereIn('student_history_id', $student_ids)
                ->where('academic_result_primary_type_id', $request->academic_result_primary_type_id)
                ->where('exam_attendance_status', true)
                ->where('fail_subject_count', '>', 0)
                ->select('id', 'student_history_id', 'academic_result_primary_type_id', 'fail_subject_count', 'gpa')
                ->get();

        }
        else if($request->result_condition=='Absent'){

            $student_result_list=SiteStudentPrimaryResultDetail::whereIn('student_history_id', $student_ids)
                ->where('academic_result_primary_type_id', $request->academic_result_primary_type_id)
                ->where('exam_attendance_status', false)
                ->select('id', 'student_history_id', 'academic_result_primary_type_id', 'fail_subject_count', 'gpa')
                ->get();
               

        }

        if($request->academic_result_primary_type_id && $request->result_condition){
            $student_history_list=$std_history_data->whereIn('id', $student_result_list->pluck('student_history_id')->unique());
        }else{
            $student_history_list=$std_history_data;
        }

//return $student_history_list;

        $data_array = array();
        if(count($student_history_list)){

            $total_student = $student_history_list->count();

            foreach (collect($student_history_list)->values() as $key => $value){

                if($request->academic_result_primary_type_id && $request->result_condition){

                    $check_student_result=$student_result_list
                        ->where('student_history_id', $value->id)
                        ->first();
                    if($check_student_result){
                        $result_gpa=$check_student_result->gpa;
                        $fail_subject_count=$check_student_result->fail_subject_count;
                    }else{
                        $result_gpa='';
                        $fail_subject_count='';
                    }

                }
                else{
                    $result_gpa='';
                    $fail_subject_count='';
                }

//                return $value;
                $payment_id = null;
                $demand_slip_id = null;
                $due_amount = 0;

                if(count($std_demand_slip_list)>0){
                    $std_demand_slip = $std_demand_slip_list->where('student_history_id', $value->id)
                        ->first();

                    if(count($std_payment_history_list)>0){
                        $std_payment_history = $std_payment_history_list->where('student_history_id', $value->id)
                            ->first();
                        if($std_payment_history){
                            if($std_payment_history->due_amount){
                                $due_amount = $std_payment_history->due_amount;
                                $payment_id = $std_payment_history->id;
//                                $demand_slip_id = $std_demand_slip ? $std_demand_slip->id : "";
//                                $demand_slip_id = "";
                            }else{
                                $due_amount = 0;
                            }
                        }else if($std_demand_slip){
                            $due_amount = $std_demand_slip->total_amount;
                            $demand_slip_id = $std_demand_slip->id;
                        }
                    }else if($std_demand_slip){
                        $due_amount = $std_demand_slip->total_amount;
                        $demand_slip_id = $std_demand_slip->id;
                    }
                }else{
                    $previous_payment_history_data = SiteStudentFeePaymentHistory::where('due_transfer_to_promoted_student_history_id', $value->id)->first();
                    if($previous_payment_history_data){
                        $due_amount = $previous_payment_history_data->due_amount;
                    }else{
                        $fine = 0;
                        $previous_payment_history_data = SiteStudentFeeDemandSlipDetails::where('due_transfer_to_promoted_student_history_id', $value->id)->first();
                        if($previous_payment_history_data){
                            $fine = SiteStudentFeeFine::where('site_student_fee_demand_slip_details_id', $previous_payment_history_data)->sum('fine_amount');
                            $due_amount = $previous_payment_history_data->total_amount + $fine;

                        }
                    }
                }

                if($value->full_name){
                    $data_array[$key]['studentDetailsData'] = $value;
                    $data_array[$key]['select_student_for_promotion_id'] = false;
                    $data_array[$key]['name'] = $value->full_name;
                    $data_array[$key]['student_roll_number'] = $value->student_roll_number;
                    $data_array[$key]['result'] = null;
                    $data_array[$key]['fail_subject'] = null;
                    $data_array[$key]['due'] = $due_amount;
                    $data_array[$key]['payment_id'] = $payment_id;
                    $data_array[$key]['demand_slip_id'] = $demand_slip_id;
                    $data_array[$key]['id'] = $value->id;
                    $data_array[$key]['result_gpa'] = $result_gpa;
                    $data_array[$key]['fail_subject_count'] = $fail_subject_count;
                }
            }
        }
        else{
            throw new Error('Sorry! student not found!');

        }
        return [$data_array,$total_student];
    }


    public function studentPromotion(Request $request)
    {

     //   dd($request->all());



        DB::beginTransaction();

        try {
           
       //     dd($request->all());

            $new_class_details = $request->new_class_details;
            $old_class_details = $request->old_class_details;
            $student_promotion_list = $request->selective_students_for_promotion;


            if($request->promotion_category == 2){

                if(!$new_class_details['academic_department_id'] && $old_class_details['academic_year_id'] == $new_class_details['academic_year_id'] && $old_class_details['academic_class_id'] == $new_class_details['academic_class_id']
                ){
                    throw new Error('Sorry! student can not be Re-admitted! Class details matched!');
                }else if(!$new_class_details['academic_class_id'] && $old_class_details['academic_year_id'] == $new_class_details['academic_year_id'] && $old_class_details['academic_department_id'] == $new_class_details['academic_department_id']){
                    throw new Error('Sorry! student can not be Re-admitted! Department details matched!');

                }
            }


            if(!$new_class_details['academic_shift_id'] || !$new_class_details['academic_class_id']){

                if(!$new_class_details['academic_department_id']){

                    throw new Error('Select * Marked Fields!');
//                return Response::json(['message' => 'Select * Marked Fields!'], 410);

                }else{
                    if($new_class_details['academic_department_id'] == $old_class_details['academic_department_id']
                        || $new_class_details['academic_year_id'] == $old_class_details['academic_year_id']){

                        throw new Error('Sorry year or department can not be same!');
//                    return Response::json(['message' => 'Select * Marked Fields!'], 410);
                    }
                }


            }else{
                if($request->promotion_category == 1){
                    if($new_class_details['academic_class_id'] == $old_class_details['academic_class_id']
                        || $new_class_details['academic_year_id'] == $old_class_details['academic_year_id']){

                        throw new Error('Sorry year or class can not be same!');
//                return Response::json(['message' => 'Promoted class same!'], 410);

                    }
                }

            }

            // if($old_class_details['academic_class_group_id'] &&  !$new_class_details['academic_class_group_id']){
            //     throw new Error('New academic class group empty!');
            // }


//            if($old_class_details['academic_session_id'] &&  $new_class_details['academic_session_id'] == 0){
//                throw new Error('New academic session empty!');
//            }

            if(!$old_class_details['academic_session_id'] &&  $new_class_details['academic_session_id']){
                throw new Error('Old academic session empty!');
            }

//            return 'ok';

            if(!$request->with_same_subject){
                $academicSubjectIDs = $this->globalAcademicSubjectList($new_class_details);
            }


            if(count($student_promotion_list)){
                foreach ($student_promotion_list as $key => $value){

                    $student_history = StudentHistory::where('id', $value['id'])->first();

                    if($request->with_same_subject){
                        $academicSubjectIDs = implode(',', $student_history->academic_subject_ids[1]);
                        $optional_subject_ids = $student_history->optional_subject_ids[1]?
                            implode(',', $student_history->optional_subject_ids[1]):null;
                        $compulsory_subject_ids = $student_history->compulsory_subject_ids[1]?
                            implode(',', $student_history->compulsory_subject_ids[1]):null;
                        $selective_compulsory_subject_ids = $student_history->selective_compulsory_subject_ids[1]?
                            implode(',', $student_history->selective_compulsory_subject_ids[1]):null;
                        $selective_markingless_subject_ids = $student_history->selective_markingless_subject_ids[1]?
                            implode(',', $student_history->selective_markingless_subject_ids[1]):null;
                        $religion_subject_id = $student_history->religion_subject_id;
                    }
                    else{
                        $optional_subject_ids = null;
                        $compulsory_subject_ids = null;
                        $selective_compulsory_subject_ids = null;
                        $selective_markingless_subject_ids = null;
                        $religion_subject_id = null;
                    }

                    $student_history->update([
                        'status' => false,
                    ]);

                    $check_exist_newly_promoted_student = StudentHistory::where('previous_student_history_id', $student_history->id)->first();
                
                    if($check_exist_newly_promoted_student) {
                       $check_exist_newly_promoted_student->update([
                            'status' => 0,
                       ]);

                     //   $check_exist_newly_promoted_student->delete();
                     //present_student_history_id
                        $check_cancel_promotion_history = StudentPromotionHistory::where('present_student_history_id', $check_exist_newly_promoted_student->id)->where('status', 1)->orderBy('id', 'DESC')->first();

                        if ($check_cancel_promotion_history) {
                            $check_cancel_promotion_history->update([
                                'status' => 0,
                            ]);
                        }
                      //  $new_std_history = $check_exist_newly_promoted_student;

                  
                    }
                    //else{}

                    $std_admission_type_id = AcademicAdmissionType::where('head_key', 'old')->first();

                    $std_history = new GlobalStudentHistory();

                    $std_history->create([
                        'site_id' => Session::get('SITE_ID'),
                        'academic_group_id' => $new_class_details['academic_group_id'],
                        'user_id' => $student_history->user_id,
                        'academic_class_group_id' => $new_class_details['academic_class_group_id']??"",
                        'academic_version_id' => $new_class_details['academic_version_id']??"",
                        'academic_year_id' => $new_class_details['academic_year_id']??"",
                        'academic_shift_id' => $new_class_details['academic_shift_id']??"",
                        'academic_class_id' => $new_class_details['academic_class_id']??"",
                        'academic_department_id' => $new_class_details['academic_department_id']??"",
                        'academic_section_id' => $request->with_same_section ? $student_history['academic_section_id']
                            : ($new_class_details['academic_section_id']),
                        'academic_class_group_id' => $request->with_same_group ? $student_history['academic_class_group_id']
                            : ($new_class_details['academic_class_group_id']),
                        'academic_session_id' => $new_class_details['academic_session_id']??"",
                        'student_roll_number' => $request->with_same_roll_number?$student_history['student_roll_number']:$value['student_roll_number'],
                        'academic_student_category_id' => $student_history['academic_student_category_id']??"",
                        'academic_transport_id' => $student_history['academic_transport_id']??"",
                        'academic_student_type_id' => $student_history['academic_student_type_id']??"",
                        'academic_student_admission_type_id' => $std_admission_type_id->id??"",
                        'previous_student_history_id' => $value['id']??"",

                        'academic_subject_ids' => $academicSubjectIDs,
                        'optional_subject_ids' => $optional_subject_ids,
                        'compulsory_subject_ids' => $compulsory_subject_ids,
                        'selective_compulsory_subject_ids' => $selective_compulsory_subject_ids,
                        'selective_markingless_subject_ids' => $selective_markingless_subject_ids,
                        'religion_subject_id' => $religion_subject_id,

                        'local_guardian_id' => $student_history['local_guardian_id']??"",
                        'previous_roll_no' => $student_history['student_roll_number'],
                        'previous_academic_class_id' => $student_history['academic_class_id']??"",
                        'status' => true,
                    ]);

                    $new_std_history =  GlobalStudentHistory::where('site_id',Session::get('SITE_ID'))
                            ->where('academic_group_id',$new_class_details['academic_group_id'])
                            ->where('user_id', $student_history->user_id)
                            ->where('status', 1)
                            ->orderBy('id','DESC')
                            ->first();
                 //  }


         
                    if($request->due_type == 1){

                        if($value['due']>0 && $value['payment_id']){
                            $std_payment_history = GlobalSiteStudentFeeDemandSlipDetails::where('site_id',Session::get('SITE_ID'))
                            ->where('academic_group_id',$new_class_details['academic_group_id'])
                            ->where('id', $value['payment_id'])->orderBy('id','DESC')->first();
                            $std_payment_history->update([
                                'due_transfer_to_promoted_student_history_id' => $new_std_history->id,
                                'previous_academic_class_due_status' => true,
                            ]);
                        }else if($value['due']>0 && $value['demand_slip_id']){
                            $std_payment_history = GlobalSiteStudentFeeDemandSlipDetails::where('site_id',Session::get('SITE_ID'))
                            ->where('academic_group_id',$new_class_details['academic_group_id'])
                            ->where('id', $value['demand_slip_id'])->orderBy('id','DESC')->first();
                            $std_payment_history->update([
                                'due_transfer_to_promoted_student_history_id' => $new_std_history->id,
                                'previous_academic_class_due_status' => true,
                            ]);
                        }
                        //==============student promotion history save===============
                       //     $studentPromotionHistory = GlobalStudentPromotionHistory::get();

                        $studentPromotionHistory = new GlobalStudentPromotionHistory();

                        $studentPromotionHistory->create([
                            'site_id' => Session::get('SITE_ID'),
                            'academic_group_id' => $new_class_details['academic_group_id'],
                            'user_id' => $student_history->user_id,
                            'previous_student_history_id' => $value['id'],
                            'present_student_history_id' => $new_std_history->id,
                            'due' => $value['due'],
                            'execution_date' => Carbon::today(),
                            'action_by' =>  Auth::user()->id,
                            'result' => null,
                            'promotion_type' => $request->promotion_type?'underconsideration':null,
                            'action_type' => 'promoted',
                            'status' => 1,
                        ]);

                    }else if($request->due_type == 2){
                        //==============student promotion history save===============

                        $studentPromotionHistory = new GlobalStudentPromotionHistory();

                        $studentPromotionHistory->create([
                            'site_id' => Session::get('SITE_ID'),
                            'academic_group_id' => $new_class_details['academic_group_id'],
                            'user_id' => $student_history->user_id,
                            'previous_student_history_id' => $value['id'],
                            'present_student_history_id' => $new_std_history->id,
                            'due' => 0,
                            'execution_date' => Carbon::today(),
                            'action_by' =>  Auth::user()->id,
                            'result' => null,
                            'promotion_type' => $request->promotion_type?'underconsideration':null,
                            'action_type' => 'promoted',
                            'status' => 1,
                        ]);

                    }

                }
            }

            DB::commit();
            return Response::json(['message' => 'Successfully', 'mode' => 'Saved!'], 200);
//            return Response::json(['message' => $message, 'mode' => 'Saved!'], 200);

        } catch (ValidationException $exception) {
            DB::rollBack();
            return JsonResponse::create(['message' => $exception->getMessage(), 'errors' => $exception->validator->getMessageBag()->toArray()], 422);
        } catch (Exception $exception) {
            DB::rollBack();
            return Response::json(['message' => $exception->getMessage()], 410);
        }


    }

    private function academicSubjectList($request)
    {
//        $data = $new_class_details->all();

//return $request;
        $subjectList = SubjectGroupConditionSetting::where('academic_class_id', $request['academic_class_id'])
            ->where('academic_year_id', $request['academic_year_id'])
            ->when(!empty($request['academic_department_id']), function ($query) use ($request) {
                return $query->where('academic_department_id', $request['academic_department_id']);
            })
            ->where('status', true)
            ->get();
//        return $subjectList;

        $general_subject_ids = [];
        foreach ($subjectList as $key => $value) {

            $academicSubjectConditionIds = explode(',', $value->academic_subject_condition_ids);

            $subjectCondition = SubjectCondition::where('condition_key', 'general')->first();

            if (in_array($subjectCondition->id, $academicSubjectConditionIds)) {
                $general_subject_ids[$key] = $value->academic_subject_id;
            }
        }

        $general_markingless_subject_ids = [];
        foreach ($subjectList as $key => $value) {

            $academicSubjectConditionIds = explode(',', $value->academic_subject_condition_ids);

            $markinglessSubjectCondition = SubjectCondition::where('condition_key', 'generalMarkingless')->first();

            if (in_array($markinglessSubjectCondition->id, $academicSubjectConditionIds)) {
                $general_markingless_subject_ids[$key] = $value->academic_subject_id;
            }
        }


        $compulsory_subject_ids = [];
        if ($request['academic_class_group_id']) {

            foreach ($subjectList as $key => $value) {

                if ($value->academic_class_group_ids) {
                    $academicClassGroupIds = explode(',', $value->academic_class_group_ids);


                    if (in_array($request['academic_class_group_id'], $academicClassGroupIds)) {
                        $academicSubjectConditionIds = explode(',', $value->academic_subject_condition_ids);

                        $subjectCondition = SubjectCondition::where('condition_key', 'compulsory')->first();

                        if (in_array($subjectCondition->id, $academicSubjectConditionIds)) {
                            $compulsory_subject_ids[$key] = $value->academic_subject_id;
                        }
                    }
                }
            }
        }
//
//        $compulsory_subject_idList = [];
//        if ($request['compulsory_subject_ids']) {
//            $compulsory_subject_idList = $request['compulsory_subject_ids'];
//        }
//        $Optional_subject_idList = [];
//        if ($request['optional_subject_ids']) {
//            $Optional_subject_idList = $request['optional_subject_ids'];
//        }
//
//        $selective_markingless_subject_idList = [];
//        if ($request['selective_markingless_subject_ids']) {
//            $selective_markingless_subject_idList = $request['selective_markingless_subject_ids'];
//        }
//
//
//        $religion_subject = [];
//        if ($request['religion_subject_id']) {
//            $religion_subject[] = $request['religion_subject_id'];
//        }
        $Subjects = array_merge(
            $general_subject_ids, $general_markingless_subject_ids,
            $compulsory_subject_ids
        );

        $academicSubjectIds = (string)implode(',', $Subjects);
        $academicSubjectIdst = array_unique(explode(',', $academicSubjectIds));
        $finalAcademicSubjectIds = (string)implode(',', $academicSubjectIdst);

        return $finalAcademicSubjectIds;
    }

    private function globalAcademicSubjectList($request)
    {
      

//return $request;
        $subjectList = GlobalSubjectGroupConditionSetting::where('site_id',Session::get('SITE_ID'))
            ->where('academic_group_id',$request['academic_group_id'])
            ->where('academic_class_id', $request['academic_class_id'])
            ->where('academic_year_id', $request['academic_year_id'])
            ->when(!empty($request['academic_department_id']), function ($query) use ($request) {
                return $query->where('academic_department_id', $request['academic_department_id']);
            })
            ->where('status', true)
            ->get();
//        return $subjectList;

        $general_subject_ids = [];
        foreach ($subjectList as $key => $value) {

            $academicSubjectConditionIds = explode(',', $value->academic_subject_condition_ids);

            $subjectCondition = SubjectCondition::where('condition_key', 'general')->first();

            if (in_array($subjectCondition->id, $academicSubjectConditionIds)) {
                $general_subject_ids[$key] = $value->academic_subject_id;
            }
        }

        $general_markingless_subject_ids = [];
        foreach ($subjectList as $key => $value) {

            $academicSubjectConditionIds = explode(',', $value->academic_subject_condition_ids);

            $markinglessSubjectCondition = SubjectCondition::where('condition_key', 'generalMarkingless')->first();

            if (in_array($markinglessSubjectCondition->id, $academicSubjectConditionIds)) {
                $general_markingless_subject_ids[$key] = $value->academic_subject_id;
            }
        }


        $compulsory_subject_ids = [];
        if ($request['academic_class_group_id']) {

            foreach ($subjectList as $key => $value) {

                if ($value->academic_class_group_ids) {
                    $academicClassGroupIds = explode(',', $value->academic_class_group_ids);


                    if (in_array($request['academic_class_group_id'], $academicClassGroupIds)) {
                        $academicSubjectConditionIds = explode(',', $value->academic_subject_condition_ids);

                        $subjectCondition = SubjectCondition::where('condition_key', 'compulsory')->first();

                        if (in_array($subjectCondition->id, $academicSubjectConditionIds)) {
                            $compulsory_subject_ids[$key] = $value->academic_subject_id;
                        }
                    }
                }
            }
        }
//
//        $compulsory_subject_idList = [];
//        if ($request['compulsory_subject_ids']) {
//            $compulsory_subject_idList = $request['compulsory_subject_ids'];
//        }
//        $Optional_subject_idList = [];
//        if ($request['optional_subject_ids']) {
//            $Optional_subject_idList = $request['optional_subject_ids'];
//        }
//
//        $selective_markingless_subject_idList = [];
//        if ($request['selective_markingless_subject_ids']) {
//            $selective_markingless_subject_idList = $request['selective_markingless_subject_ids'];
//        }
//
//
//        $religion_subject = [];
//        if ($request['religion_subject_id']) {
//            $religion_subject[] = $request['religion_subject_id'];
//        }
        $Subjects = array_merge(
            $general_subject_ids, $general_markingless_subject_ids,
            $compulsory_subject_ids
        );

        $academicSubjectIds = (string)implode(',', $Subjects);
        $academicSubjectIdst = array_unique(explode(',', $academicSubjectIds));
        $finalAcademicSubjectIds = (string)implode(',', $academicSubjectIdst);

        return $finalAcademicSubjectIds;
    }

    public function studentPromotionCancel(Request $request)
    {
//        return $request;

        $data = $request->selective_students_for_promotion_cancel;

        foreach ($data as $key => $value){
            if($value['select_student_for_promotion_id']){
                $std_history_data = StudentHistory::where('id', $value['id'])->first();
                if($std_history_data->previous_student_history_id){

                    //======================check present payment=========================
                    $check_std_present_payment = SiteStudentFeeDemandSlipDetails::where('student_history_id', $value['id'])->where('status', 1)->orderBy('id','DESC')->first();
                    if($check_std_present_payment){
                        throw new Error('Sorry! Can not be canceled! demand slip already generated!');
                    }else{
                        $check_std_present_payment = SiteStudentFeePaymentHistory::where('student_history_id', $value['id'])->orderBy('id','DESC')->first();
                        if($check_std_present_payment){
                            throw new Error('Sorry! Can not be canceled! payment already taken!');
                        }

                    }

                    //====================check previous due and active=========================
                    $std_demand_slip_details = SiteStudentFeeDemandSlipDetails::where('due_transfer_to_promoted_student_history_id', $value['id'])->where('previous_academic_class_due_status', true)->orderBy('id','DESC')->first();
                    if($std_demand_slip_details){
                        $std_demand_slip_details->update([
                            'due_transfer_to_promoted_student_history_id' => null,
                            'previous_academic_class_due_status' => false,
                            'status' => 1,
                        ]);
                    }

                    $std_payment_history = SiteStudentFeePaymentHistory::where('due_transfer_to_promoted_student_history_id', $value['id'])->where('previous_academic_class_due_status', true)->orderBy('id','DESC')->first();
                    if($std_payment_history){
                        $std_payment_history->update([
                            'due_transfer_to_promoted_student_history_id' => null,
                            'previous_academic_class_due_status' => false,
                            'status' => 1,
                        ]);
                    }


                    //=======================update student history and student promotion history===========================
                    $previous_std_history_data = GlobalStudentHistory::where('id', $std_history_data->previous_student_history_id)->first();
                    if($previous_std_history_data){

                        $previous_std_history_data->update([
                            'status' => 1,
                        ]);
                        $std_history_data->update([
                            'status' => 0,
                        ]);

//                        $std_promotion_history_data = StudentPromotionHistory::where('present_student_history_id', $std_history_data->id)->where('action_type','promoted')->where('status',1)->first();
                        $std_promotion_history_data = StudentPromotionHistory::where('present_student_history_id', $std_history_data->id)->where('status',1)->orderBy('id', 'DESC')->first();
                        $std_promotion_history_data->update([
                            'status' => 0,
                        ]);

                        $std_promotin_history = new GlobalStudentPromotionHistory();
                        $std_promotin_history->insert([
                            'user_id' => $std_promotion_history_data->user_id,
                            'previous_student_history_id' => $std_promotion_history_data->previous_student_history_id,
                            'present_student_history_id' => $std_promotion_history_data->present_student_history_id,
                            'due' => $std_promotion_history_data->due,
                            'execution_date' => Carbon::today(),
                            'action_by' =>  Auth::user()->id,
                            'result' => $std_promotion_history_data->result,
                            'promotion_type' => $std_promotion_history_data->promotion_type,
                            'site_id' => $std_promotion_history_data->site_id,
                            'academic_group_id' => $std_promotion_history_data->academic_group_id,
                            'status' => 1,
                            'action_type' => 'canceled',
                            'previous_std_promotion_history_id' => $std_promotion_history_data->id,

                        ]);
                    }else{
                        throw new Error('Sorry! Promotion not found for cancellation!');

                    }


                }else{
                    throw new Error('Sorry! Promotion not given at yet!');

                }


            }

        }

    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    public function getAllClassSection(Request $request)
    {
//        return $request;
        $class_id = $request->academic_class_id;
        $department_id = $request->academic_department_id;
        $class_group_id = $request->academic_class_group_id;
        $session_id= $request->academic_session_id;

//        $site_shift_class_section = SiteShiftClassGroupSectionSetting::where('academic_class_id',  $request->academic_class_id )->where('academic_year_id', )->first();
//        return $site_shift_class_section;


        $site_shift_class_section = SiteShiftClassGroupSectionSetting::where('academic_year_id', $request->academic_year_id)
                                                                        ->where('academic_shift_id', $request->academic_shift_id)
                                                                        ->when($class_id, function ($query) use($class_id){
                                                                            return $query->where('academic_class_id', $class_id);
                                                                        })
                                                                        ->when($department_id, function ($query) use($department_id){
                                                                            return $query->where('academic_department_id', $department_id);
                                                                        })
                                                                        ->when($class_group_id, function ($query) use($class_group_id){
                                                                            return $query->where('academic_class_group_id', $class_group_id);
                                                                        })
                                                                        ->when($session_id, function ($query) use($session_id){
                                                                            return $query->where('academic_session_id', $session_id);
                                                                        })->first();

        if($site_shift_class_section){
            $section_ids = explode(',', $site_shift_class_section->academic_section_ids);
            $academic_class_section = AcademicSection::whereIn('id', $section_ids)->get();
            return $academic_class_section;
        }

    }

    public function getAllStudentList(Request $request)
    {
    //   return $request;
        $data = $request->all();
        $siteStudentList = StudentHistory::with('student')
                            ->with('section')
                            ->where('academic_version_id', $request->academic_version_id)
                            ->where('academic_shift_id', $request->academic_shift_id)
                            ->where('academic_year_id', $request->academic_year_id)
                            ->where('academic_class_id', $request->academic_class_id)
                            ->where('status', true)
                            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                                return $query->where('academic_department_id', $data['academic_department_id']);
                            })
                            ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                                return $query->where('academic_class_group_id', $data['academic_class_group_id']);
                            })
                            ->when(!empty($data['academic_session_id']), function ($query) use ($data) {
                                return $query->where('academic_session_id', $data['academic_session_id']);
                            })
                            ->orderBy('academic_department_id')
                            ->orderBy('academic_class_id')
                            ->orderBy('academic_class_group_id')
                            ->orderBy('academic_section_id')
                            ->orderBy('student_roll_number')
                            ->get();
//        return $siteStudentList;

        if($siteStudentList){
            $data = array();
            foreach ($siteStudentList as $key => $value){
//                return $value->section->section_name;
                $data[$key]['dataList'] = $value;
                $data[$key]['student_history_id'] = $value->id;
                $data[$key]['name'] = $value->full_name;
                $data[$key]['student_roll_number'] = $value->student_roll_number;
                $data[$key]['section'] = $value->section->section_name??null;
                if($value->section && $value->section->id === $request->academic_section_id){
                    $data[$key]['active_section_id'] = true;
                }else{
                    $data[$key]['active_section_id'] = false;
                }


            }
        }
        return $data;
    }

    public function studentSectionAssign(Request $request){

        $form_data =  $request->formData;
        foreach ($request->studentList as $key => $value){

            if($value['active_section_id']){
                StudentHistory::where('id',$value['student_history_id'])->update([
                    'academic_section_id' => $form_data['academic_section_id']
                ]);

            }
        }

        return Response::json(['message' => 'Successfully', 'mode' => 'Saved!'], 200);


    }
    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
